//=============================================================================
// Mafobar.
//=============================================================================
class MafoBar extends MSMTLWafoBars;

#exec TEXTURE IMPORT NAME="MafoBarTex1" FILE="C:\DeusEx\MarkistanCity\Textures\MafoBarTex1.pcx" GROUP=Skins

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

defaultproperties
{
     healAmount=20
     maxCopies=15
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="PoppySeed Mafo Bar"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Candybar'
     PickupViewMesh=LodMesh'DeusExItems.Candybar'
     ThirdPersonMesh=LodMesh'DeusExItems.Candybar'
     Icon=Texture'Markistan.Icons.BeltIconWafoBar'
     largeIcon=Texture'Markistan.Icons.BeltIconWafoBar'
     largeIconWidth=46
     largeIconHeight=36
     Description="A new brand of candy bar that seems to rip off wafo bars!"
     beltDescription="MAFO POPY"
     Skin=Texture'MarkistanCity.Skins.MafoBarTex1'
     Mesh=LodMesh'DeusExItems.Candybar'
     CollisionRadius=6.250000
     CollisionHeight=0.670000
     Mass=3.000000
     Buoyancy=4.000000
}
